<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Auth\Notifications\ResetPassword;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;


class User extends Authenticatable
{
    use SoftDeletes, Notifiable;

    protected $fillable = [
        'name',
        'email',
		'mobile',
		'country',
        'password',
        'mypass',
        'created_at',
        'updated_at',
        'deleted_at',
        'remember_token',
        'email_verified_at',
		'groupname',
		'afid',
		'affiliate',
		'promo',
        'usermanager',
        'mt4access',
        'deposit',
        'withdrawal',
        'leads',
        'issubadmin'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $dates = [
        'updated_at',
        'created_at',
        'deleted_at',
        'email_verified_at'
    ];

    public function getEmailVerifiedAtAttribute($value)
    {
        return $value ? Carbon::createFromFormat('Y-m-d H:i:s', $value)->format(config('panel.date_format') . ' ' . config('panel.time_format')) : null;
    }

    public function setEmailVerifiedAtAttribute($value)
    {
        $this->attributes['email_verified_at'] = $value ? Carbon::createFromFormat(config('panel.date_format') . ' ' . config('panel.time_format'), $value)->format('Y-m-d H:i:s') : null;
    }

    public function setPasswordAttribute($input)
    {
        if ($input) {
            $this->attributes['password'] = app('hash')->needsRehash($input) ? Hash::make($input) : $input;
        }
    }

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPassword($token));
    }

    public function roles()
    {
        return $this->belongsToMany(Role::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::created(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'create',
                'description'  => 'Created ' . get_class($model),
                'ip_address'   => request()->ip(),
            ]);
        });

        static::updated(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'update',
                'description'  => 'Updated ' . get_class($model),
                'ip_address'   => request()->ip(),
            ]);
        });

        static::deleted(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'delete',
                'description'  => 'Deleted ' . get_class($model),
                'ip_address'   => request()->ip(),
            ]);
        });
    }
}
