<?php

namespace App\Http\Controllers;

use App\Models\Deposit;
use App\Models\Leads;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class ApiController extends Controller
{
    public function autologin(Request $request)
    {
        //Auth::loginUsingId(2);
        $parts = parse_url($_SERVER['REQUEST_URI']);
        $email = '';
        $userget = '';
        if (!empty($parts['query'])) {
            parse_str($parts['query'], $query);

            if (!empty($query['email'])) {
                $email = $query['email'];
                $userget = User::select('id')->where('email', $email)->first();
            }
        }
        if (empty($userget)) {
            $array = array('status' => false, 'error' => 'no user found');
            return response()->json($array);
        }
        if (empty($email) && empty($userget)) {
            $array = array('status' => false, 'error' => 'token invalid');
            return response()->json($array);
        } else {
            Auth::loginUsingId($userget->id);
            return redirect('admin');
        }
    }
    public function getleads(Request $request)
    {
        $apikey = 'gro@Q[(GQd#dkbJH';
        $parts = parse_url($_SERVER['REQUEST_URI']);
        $key = $source = $status = $start = $end = '';
        if (!empty($parts['query'])) {
            parse_str($parts['query'], $query);
            $key = $query['key'];
            $source = $query['source'];
            if (!empty($query['status'])) {
                $status = $query['status'];
            }
            if (!empty($query['start_date'])) {
                $start = $query['start_date'];
            }
            if (!empty($query['end_date'])) {
                $end = $query['end_date'];
            }
        }
        if (empty($source)) {
            $array = array('status' => false, 'error' => 'invalid parameters');
            return response()->json($array);
        }
        if ($key != $apikey) {
            $array = array('status' => false, 'error' => 'invalid API key');
            return response()->json($array);
        } else {

            $leads = Leads::select('id as lead_no', 'firstname', 'lastname', 'email', 'password', 'country', 'mobile', 'source', 'status', 'created_at as date')->where('source', $source)->get();
            if (count($leads) == 0) {
                $array = array('status' => false, 'error' => 'no lead found');
                return response()->json($array);
            }
            if (!empty($status)) {
                $leads = Leads::select('id as lead_no', 'firstname', 'lastname', 'email', 'password', 'country', 'mobile', 'source', 'status', 'created_at as date')->where('source', $source)->where('status', $status)->get();
            }
            if (!empty($start) && !empty($end) && !empty($status)) {
                $sdate = date('Y-m-d 00:00:00', strtotime($start));
                $edate = date('Y-m-d 23:59:59', strtotime($end));
                $leads = Leads::select('id as lead_no', 'firstname', 'lastname', 'email', 'password', 'country', 'mobile', 'source', 'status', 'created_at as date')->where('source', $source)->where('status', $status)->whereBetween('created_at', [$sdate, $edate])->get();
            }
            if (!empty($start) && !empty($end) && empty($status)) {
                $sdate = date('Y-m-d 00:00:00', strtotime($start));
                $edate = date('Y-m-d 23:59:59', strtotime($end));
                $leads = Leads::select('id as lead_no', 'firstname', 'lastname', 'email', 'password', 'country', 'mobile', 'source', 'status', 'created_at as date')->where('source', $source)->whereBetween('created_at', [$sdate, $edate])->get();
            }
            return response()->json(array('status' => true, 'response' => $leads));
        }
    }
    public function createlead(Request $request)
    {
        $apikey = '9jntq5L9u3x1WAn';
        if ($request->key != $apikey) {
            $array = array('status' => false, 'error' => 'invalid API key');
            return response()->json($array);
        } else {
            $checkuserc = User::where('email', $request->email)->count();
            if ($checkuserc > 0) {
                $array = array('status' => false, 'error' => 'user already exist');
                return response()->json($array);
            }

            $leadschec = Leads::where('email', $request->email)->count();
            if ($leadschec > 0) {
                $array = array('status' => false, 'error' => 'email already exist');
                return response()->json($array);
            }
            $checkcode = DB::table('country')->select('phonecode')->where('nicename', $data['country'])->first();
            $adduser = array();
            $adduser['name'] = $request->first_name . ' ' . $request->last_name;
            $adduser['email'] = $request->email;
            if (!empty($checkcode)) {
                $adduser['mobile'] = '+' . $checkcode->phonecode . $request->mobile_num;
            } else {
                $adduser['mobile'] = $request->mobile_num;
            }
            $adduser['country'] = $request->country;
            $adduser['password'] = Hash::make($request->password);
            $adduser['mypass'] = base64_encode($request->password);
            $adduser['status'] = '2';
            $adduser['walt'] = '1';
            $adduser['depositallow'] = '1';
            $newuser = User::create($adduser);
            $newuser->roles()->sync(2);

            $inputdata = array();
            $inputdata['firstname'] = $request->first_name;
            $inputdata['lastname'] = $request->last_name;
            $inputdata['email'] = $request->email;
            $inputdata['password'] = $request->password;
            $inputdata['country'] = $request->country;
            if (!empty($checkcode)) {
                $inputdata['mobile'] = '+' . $checkcode->phonecode . $request->mobile_num;
            } else {
                $inputdata['mobile'] = $request->mobile_num;
            }
            $inputdata['source'] = $request->source;
            $inputdata['status'] = $request->status;
            if ($addlead = Leads::create($inputdata)) {
                return response()->json(['status' => true, 'lead_no' => $addlead->id]);
            } else {
                $array = array('status' => false);
                return response()->json($array);
            }
        }
    }

    public function getleadstatus(Request $request)
    {
        $apikey = '9jntq5L9u3x1WAn';
        $parts = parse_url($_SERVER['REQUEST_URI']);
        $key = $leadno = $source = '';
        if (!empty($parts['query'])) {
            parse_str($parts['query'], $query);
            $key = $query['key'];
            if (!empty($query['lead_no'])) {
                $leadno = $query['lead_no'];
            }
            if (!empty($query['source'])) {
                $source = $query['source'];
            }
        }

        if (empty($leadno) || empty($source)) {
            $array = array('status' => false, 'error' => 'invalid parameters');
            return response()->json($array);
        }

        if ($key != $apikey) {
            $array = array('status' => false, 'error' => 'invalid API key');
            return response()->json($array);
        } else {

            $leads = Leads::select('status', 'id as lead_no', 'email')->where('source', $source)->where('id', $leadno)->first();
            if (empty($leads)) {
                $array = array('status' => false, 'error' => 'no leads found');
                return response()->json($array);
            }
            return response()->json(array('status' => true, 'response' => $leads));
        }
    }

    public function depositlist(Request $request)
    {
        $apikey = '9jntq5L9u3x1WAn';
        $parts = parse_url($_SERVER['REQUEST_URI']);
        $key = $email = $start = $source = $end = '';
        if (!empty($parts['query'])) {
            parse_str($parts['query'], $query);
            $key = $query['key'];
            if (!empty($query['email'])) {
                $email = $query['email'];
            }
            if (!empty($query['start_date'])) {
                $start = $query['start_date'];
            }
            if (!empty($query['end_date'])) {
                $end = $query['end_date'];
            }
            if (!empty($query['source'])) {
                $source = $query['source'];
            }
        }
        if (empty($source)) {
            //  return 'invalid parameters';
            $array = array('status' => false, 'error' => 'invalid parameters');
            return response()->json($array);
        }
        if ($key != $apikey) {
            $array = array('status' => false, 'error' => 'invalid API key');
            return response()->json($array);
        } else {

            $allusers = User::select('id')->where('walt', '1')->get();
            $uids = array();
            foreach ($allusers as $client) {
                $uids[] = $client->id;
            }
            if (!empty($email)) {
                $checkuser = User::select('id')->where('email', $email)->first();
                $checkld = Leads::select('id')->where('email', $email)->where('source', $source)->first();
                if (empty($checkuser) || empty($checkld)) {
                    $array = array('status' => false, 'error' => 'no result found');
                    return response()->json($array);
                }
                $leads = Deposit::select('userid', 'amount', 'created_at as date')->where('userid', $checkuser->id)->where('displaystatus', '1')->get();

                if (empty($leads)) {
                    $array = array('status' => false, 'error' => 'no data found');
                    return response()->json($array);
                }
                if (!empty($start) && !empty($end)) {
                    $sdate = date('Y-m-d 00:00:00', strtotime($start));
                    $edate = date('Y-m-d 23:59:59', strtotime($end));
                    $leads = Deposit::select('userid', 'amount', 'created_at as date')->where('userid', $checkuser->id)->whereBetween('created_at', [$sdate, $edate])->where('displaystatus', '1')->get();
                }
            } else {
                $leads = Deposit::select('userid', 'amount', 'created_at as date')->whereIn('userid', $uids)->where('displaystatus', '1')->groupBy('userid')->orderBy('created_at', 'desc')->get();
                if (empty($leads)) {
                    $array = array('status' => false, 'error' => 'no data found');
                    return response()->json($array);
                }

                if (!empty($start) && !empty($end)) {
                    $sdate = date('Y-m-d 00:00:00', strtotime($start));
                    $edate = date('Y-m-d 23:59:59', strtotime($end));
                    $leads = Deposit::select('userid', 'amount', 'created_at as date')->whereIn('userid', $uids)->whereBetween('created_at', [$sdate, $edate])->where('displaystatus', '1')->groupBy('userid')->orderBy('created_at', 'desc')->get();
                }
            }
            $arraydata = array();
            foreach ($leads as $i => $lead) {
                $getus = User::select('id', 'email')->where('id', $lead->userid)->first();
                $getld = Leads::select('id')->where('source', $source)->where('email', $getus->email)->first();
                if (!empty($getld)) {
                    $arraydata[$i]['amount'] = $lead->amount;
                    $arraydata[$i]['date'] = $lead->date;
                    $arraydata[$i]['email'] = $getus->email;
                    $arraydata[$i]['lead_no'] = $getld->id;
                }
            }

            return response()->json(array('status' => true, 'response' => $arraydata));
        }
    }
}
