<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.register');
    }

    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Handle an incoming registration request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request)
    {
        $request->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|confirmed|min:8',
        ]);

        Auth::login($user = User::create([
            'username' => strtolower($request->first_name).strtolower($request->last_name),
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'phone_number' => $request->phone_number,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'user_type' => 'user'
        ]));

        $user->assignRole('user');

        event(new Registered($user));

        return redirect(RouteServiceProvider::HOME);
    }

    public function bitpayment(Request $request)
    {

        if ($request->status == 'paid') {
            $this->makeconnection();
            $getdeposit = Deposit::where('id', $request->order_id)->first();
            $percntage = $request->amount * 0.06;
            $finalamount = $request->amount - $percntage;

            $comnt = 'deposit-bitlocus';

            $url = $this->apicall . 'MAKE_DEPOIST_BALANCE?MT4Account=' . $getdeposit->mt4account . '&Amount=' . $finalamount . '&Comment=' . $comnt . '&ManagerIndex=' . $this->manager;
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            $getdata = json_decode($result);
            curl_close($ch);

            Deposit::where('id', $request->order_id)->update(array(
                'status'     => '1',
                'displaystatus'     => '1',
            ));
        }
    }
    public function checkcbi()
    {
        $post = array(
            'trader' =>
            (object) array(
                'label' => 'finanza',
                'amount' => '10',
                'depoid' => 45,
                'custom2' => 'payment',
                'callback_url' => 'https://crm.finanza-invest.com/dopayment',
            ),
            'transaction' =>
            array(
                'id' => 'GP103069',
                'currency' => 'EUR',
                'currency_amount' => 10.0,
                'crypto' => 'BTC',
                'crypto_amount' => '0.00107424',
                'completed_at' => '2020-07-27 08:13:36',
            ),
            'status' => 'Declined',
            'user' =>
            array(
                'first_name' => 'Bill',
                'last_name' => 'Zolti',
                'email' => 'support@allfinancialmarket.com',
            ),
            'error_message' => 'Issuer country in blacklist',
            'card_last_four' => '1111',
            'buy_percentage_fee' => '6',
        );
        dd($post);
    }
    public function dopayment(Request $request)
    {
        //$this->makeconnection();
        if ($request['status'] == 'Completed' || $request['status'] == 'completed' || $request['status'] == 'success' || $request['status'] == 'Success') {
            $checkdepo = Deposit::where('id', $request['trader']->depoid)->first();
            $comnt = 'deposit-allglobal';

            //   $url = $this->apicall.'MAKE_DEPOIST_BALANCE?MT4Account='.$checkdepo->mt4account.'&Amount='.$request->amount.'&Comment='.$comnt.'&ManagerIndex='.$this->manager;
            $postfields = array(
                'method' => 'Deposit',
                'key' => '0001',
                'array' =>
                array(
                    0 =>
                    array(
                        'index' => 0,
                        'accountID' => $checkdepo->mt4account,
                        'comment' => $comnt,
                        'amount' => $request['trader']->amount,
                    ),
                ),
            );
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => "http://jenya.securedns.us:3001/capitalmanageinv",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode($postfields),
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: text/plain"
                ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);
            $getresult = json_decode($response);

            if ($getresult->applicationStatus == 'OK') {
                Deposit::where('id', $request['trader']->depoid)->update(array(
                    'displaystatus'     => '1',
                ));
            }
        }
    }
}
