<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyProductRequest;
use App\Http\Requests\UpdateProductRequest;
use App\Models\Creditin;
use App\Models\Mtaccount;
use App\Models\Product;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;

class CreditinController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $accounts = Creditin::where('userid', Auth::user()->id)->where('displaystatus', '1')->get();

        return view('admin.creditin.index', compact('accounts'));
    }

    public function adminindex()
    {
        $checkadmin = Gate::allows('permission_create');
        if ($checkadmin == true) {
            // $accounts = Mtaccount::get();
            $accounts = DB::table('creditin')
                ->join('users', 'creditin.userid', '=', 'users.id')
                ->select('users.name', 'users.email', 'creditin.*')
                ->where('creditin.displaystatus', '1')
                ->get();
        } elseif ($checkadmin == false && Auth::user()->affiliate == '1') {
            $accounts = DB::table('creditin')
                ->join('users', 'creditin.userid', '=', 'users.id')
                ->select('users.name', 'users.email', 'creditin.*')
                ->where('users.afid', Auth::user()->id)
                ->where('creditin.displaystatus', '1')
                ->get();
        } elseif ($checkadmin == false && Auth::user()->affiliate == '1' && Auth::user()->issubadmin == '1') {
            $getafids = User::select('id')->where('afid', Auth::user()->id)->pluck('id')->toArray();
            $getallids = User::select('id')->whereIn('afid', $getafids)->pluck('id')->toArray();
            $finalids = array_merge($getafids, $getallids);
            $accounts = DB::table('creditin')
                ->join('users', 'creditin.userid', '=', 'users.id')
                ->select('users.name', 'users.email', 'creditin.*')
                ->whereIn('users.id', $finalids)
                ->where('creditin.displaystatus', '1')
                ->get();
        } elseif ($checkadmin == false && Auth::user()->issubadmin == '1') {
            $getafids = User::select('id')->where('afid', Auth::user()->id)->pluck('id')->toArray();
            $getallids = User::select('id')->whereIn('afid', $getafids)->pluck('id')->toArray();
            $finalids = array_merge($getafids, $getallids);
            $accounts = DB::table('creditin')
                ->join('users', 'creditin.userid', '=', 'users.id')
                ->select('users.name', 'users.email', 'creditin.*')
                ->whereIn('users.id', $finalids)
                ->where('creditin.displaystatus', '1')
                ->get();
        } else {
            abort(403);
        }
        return view('admin.creditin.adminindex', compact('accounts'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $accounts = Mtaccount::where('userid', Auth::user()->id)->get();
        return view('admin.creditin.create', compact('accounts'));
    }

    public function creditindepo()
    {
        $mt5id = '';
        $email  = '';
        $parts = parse_url($_SERVER['REQUEST_URI']);
        if (!empty($parts['query'])) {
            parse_str($parts['query'], $query);
            if (isset($query['mt5id'])) {
                $mt5id = $query['mt5id'];
            }
            if (isset($query['email'])) {
                $email = $query['email'];
            }
        } else {
            $mt5id = '';
            $email = '';
        }

        $checkadmin = Gate::allows('permission_create');
        if ($checkadmin == true) {
            // $accounts = Mtaccount::get();
            $accounts = DB::table('mtaccount')
                ->join('users', 'mtaccount.userid', '=', 'users.id')
                ->select('users.name', 'users.email', 'mtaccount.*')
                ->get();
        } elseif ($checkadmin == false && Auth::user()->affiliate == '1') {
            $accounts = DB::table('mtaccount')
                ->join('users', 'mtaccount.userid', '=', 'users.id')
                ->select('users.name', 'users.email', 'mtaccount.*')
                ->where('users.afid', Auth::user()->id)
                ->get();
        } elseif ($checkadmin == false && Auth::user()->issubadmin == '1') {
            $getafids = User::select('id')->where('afid', Auth::user()->id)->pluck('id')->toArray();
            $getallids = User::select('id')->whereIn('afid', $getafids)->pluck('id')->toArray();
            $finalids = array_merge($getafids, $getallids);
            if (!empty($mt5id)) {
                $accounts = DB::table('users')
                    ->join('mtaccount', 'users.id', '=', 'mtaccount.userid')
                    ->select('users.name', 'users.email', 'mtaccount.*')
                    ->whereIn('users.id', $finalids)
                    ->where('mtaccount.loginid', 'like', '%' . $mt5id . '%')
                    ->orderBy('id', 'DESC')->paginate(600);
            } else {
                $accounts = DB::table('users')
                    ->join('mtaccount', 'users.id', '=', 'mtaccount.userid')
                    ->select('users.name', 'users.email', 'mtaccount.*')
                    ->whereIn('users.id', $finalids)
                    ->orderBy('id', 'DESC')->paginate(600);
            }
        } else {
            abort(403);
        }

        return view('admin.creditin.manual', compact('accounts'));
    }

    public function storecreditin(Request $request)
    {
        //$this->makeconnection();
        // abort_unless(\Gate::allows('product_create'), 403);
        $checkde = Mtaccount::where('loginid', $request->mt4account)->first();
        $comnt = 'creditin';

        //  $url = $this->apicall.'MAKE_DEPOIST_BALANCE?MT4Account='.$request->mt4account.'&Amount='.$request->amount.'&Comment='.$comnt.'&ManagerIndex='.$this->manager;


        $urlw = 'http://api.tradeactive.com/mt5demo/api/api.php?MODE=Credit';
        $postdata1 = array();
        $postdata1['LOGIN'] = $request->mt4account;
        $postdata1['TYPE'] = 2;
        $postdata1['BALANCE'] = $request->amount;
        $postdata1['CHECK_MARGIN'] = '1';
        $option = array(
            'Content-Type:application/json'
        );
        $ch1 = curl_init(str_replace(' ', '', $urlw));
        curl_setopt($ch1, CURLOPT_HTTPHEADER, $option);
        curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch1, CURLOPT_POST, true); // Specify the request method as POST
        curl_setopt($ch1, CURLOPT_POSTFIELDS, json_encode($postdata1));
        $getallw1 = curl_exec($ch1);
        curl_close($ch1);
        $getuserdata1 = json_decode($getallw1);
        if ($getuserdata1->status == 'success') {
            $data = $request->all();
            $adduser = array();
            $adduser['mt4account'] = $data['mt4account'];
            $adduser['userid'] = $checkde->userid;
            $adduser['amount'] = $data['amount'];
            $adduser['description'] = $data['description'];
            $adduser['status'] = '1';
            $adduser['displaystatus'] = '1';

            $product = Creditin::create($adduser);
        }
        return redirect()->route('admin.creditinlist')->with('success', 'CreditIn successfully');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $adduser = array();
        $adduser['mt4account'] = $data['mt4account'];
        $adduser['userid'] = Auth::user()->id;
        $adduser['amount'] = $data['amount'];
        $adduser['description'] = $data['description'];
        $adduser['displaystatus'] = '0';
        $product = Creditin::create($adduser);

        return redirect()->route('admin.creditinlist');
    }

    /**
     * Display the specified resource.
     */
    public function show(Product $product)
    {
        abort_unless(Gate::allows('product_show'), 403);

        return view('admin.products.show', compact('product'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Product $product)
    {
        //  abort_unless(\Gate::allows('product_edit'), 403);

        return view('admin.products.edit', compact('product'));
    }

    public function update(UpdateProductRequest $request, Product $product)
    {
        // abort_unless(\Gate::allows('product_edit'), 403);

        $product->update($request->all());

        return redirect()->route('admin.products.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Product $product)
    {
        abort_unless(Gate::allows('product_delete'), 403);

        $product->delete();

        return back();
    }

    public function massDestroy(MassDestroyProductRequest $request)
    {
        Product::whereIn('id', request('ids'))->delete();

        return response(null, 204);
    }
}
