<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class Leverage extends Model
{
    use SoftDeletes;

		protected $table = 'leverage';

		protected $primaryKey = 'id';

	protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'mtaccount',
        'leverage',
        'userid',
        'status'
    ];

    protected static function boot()
    {
        parent::boot();

        static::created(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            $createdAttributes = [];
            if ($model->name) {
                $createdAttributes[] = "name: '{$model->name}'";
            }
            if ($model->email) {
                $createdAttributes[] = "email: '{$model->email}'";
            }

            $description = 'Created ' . class_basename($model);
            if (!empty($createdAttributes)) {
                $description .= ' (' . implode(', ', $createdAttributes) . ')';
            }

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'create',
                'description'  => $description,
                'ip_address'   => request()->ip(),
            ]);
        });

        static::updated(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            $changes = $model->getChanges();
            $original = $model->getOriginal();

            $changedFields = [];
            foreach ($changes as $attribute => $newValue) {
                if ($attribute === 'updated_at') {
                    continue;
                }
                $oldValue = $original[$attribute] ?? null;
                $changedFields[] = "$attribute: '$oldValue' → '$newValue'";
            }

            $description = 'Updated ' . class_basename($model);
            if (!empty($changedFields)) {
                $description .= ' (' . implode(', ', $changedFields) . ')';
            }

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'update',
                'description'  => $description,
                'ip_address'   => request()->ip(),
            ]);
        });

        static::deleted(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'delete',
                'description'  => 'Deleted ' . class_basename($model),
                'ip_address'   => request()->ip(),
            ]);
        });
    }
}
