<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <script src="https://static.sumsub.com/idensic/static/sns-websdk-builder.js"></script>
                        <div class="box">
                            <div class="box-header">
                                <h3 class="box-title">Document Upload</h3>
                            </div>
                            <div class="box-body">
                                <ul>
                                    <!--<li>@lang('translate.sumsb1')</li>
                                    <li>@lang('translate.sumsb2')</li>-->
                                </ul>
                                <div id="sumsub-websdk-container"></div>
                            </div>
                        </div>
                        <script>
                            function launchWebSdk(accessToken, applicantEmail, applicantPhone) {
                                let snsWebSdkInstance = snsWebSdk.init(
                                        accessToken,
                                        () => this.getNewAccessToken()
                                    )
                                    .withConf({
                                        lang: '<?php if (App::getLocale() == 'vn') {
                                            echo 'vi';
                                        } else {
                                            echo App::getLocale();
                                        } ?>',
                                        email: applicantEmail,
                                        phone: applicantPhone,
                                        i18n: {
                                            "document": {
                                                "subTitles": {
                                                    "IDENTITY": "Upload a document that proves your identity"
                                                }
                                            }
                                        },
                                        onMessage: (type, payload) => {
                                            console.log('WebSDK onMessage', type, payload);
                                            console.log('in1');
                                        },
                                        uiConf: {
                                            customCssStr: ":root {\n  --black: #000000;\n   --grey: #F5F5F5;\n  --grey-darker: #B2B2B2;\n  --border-color: #DBDBDB;\n}\n\np {\n  color: var(--black);\n  font-size: 16px;\n  line-height: 24px;\n}\n\nsection {\n  margin: 40px auto;\n}\n\ninput {\n  color: var(--black);\n  font-weight: 600;\n  outline: none;\n}\n\nsection.content {\n  background-color: var(--grey);\n  color: var(--black);\n  padding: 40px 40px 16px;\n  box-shadow: none;\n  border-radius: 6px;\n}\n\nbutton.submit,\nbutton.back {\n  text-transform: capitalize;\n  border-radius: 6px;\n  height: 48px;\n  padding: 0 30px;\n  font-size: 16px;\n  background-image: none !important;\n  transform: none !important;\n  box-shadow: none !important;\n  transition: all 0.2s linear;\n}\n\nbutton.submit {\n  min-width: 132px;\n  background: none;\n  background-color: var(--black);\n}\n\n.round-icon {\n  background-color: var(--black) !important;\n  background-image: none !important;\n}"
                                        },
                                        onError: (error) => {
                                            console.error('WebSDK onError', error);
                                            console.log('in2');
                                        },
                                    })
                                    .withOptions({
                                        addViewportTag: false,
                                        adaptIframeHeight: true
                                    })
                                    .on('idCheck.onStepCompleted', (payload) => {
                                        console.log('onStepCompleted', payload);
                                        console.log('in3');
                                    })
                                    .on('idCheck.onError', (error) => {
                                        console.log('onError', payload);
                                        console.log('in4');
                                    })
                                    .onMessage((type, payload) => {
                                        console.log('onMessage', type, payload);
                                        console.log('in5');
                                    })
                                    .build();
                                snsWebSdkInstance.launch('#sumsub-websdk-container')
                            }

                            function getNewAccessToken() {
                                return Promise.resolve($NEW_ACCESS_TOKEN)
                            }

                            launchWebSdk('<?php echo $subtoken; ?>', '<?php echo Auth::user()->email; ?>', '<?php echo Auth::user()->phone; ?>')
                        </script>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
