<?php

namespace App\Http\Controllers;

use App\Models\AffiliateKey;
use Illuminate\Http\Request;

class AffiliateApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $affiliatekey = AffiliateKey::all();
        return view('admin.affiliatekey.index',compact('affiliatekey'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.affiliatekey.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $affiliatekey = new AffiliateKey();
        $affiliatekey->source = $request->input('source');
        $affiliatekey->api_key = $request->input('apikey');
        $affiliatekey->save();

        return redirect('apikeys')->with('success','API Key added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $affiliatekey = AffiliateKey::findOrFail($id);

        $affiliatekey->delete();

        return redirect('apikeys')->with('status','API Key deleted successfully');
    }
}
