<?php

namespace App\Listeners;

use App\Models\Log;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class LogUserLogout
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(object $event): void
    {
        $user = $event->user;
        $userRoles = $user->roles->pluck('title')->implode(', ');

        Log::create([
            'role'    => $userRoles,
            'user_id'      => $user->id,
            'action'       => 'logout',
            'description'  => 'User logged out',
            'ip_address'   => $user->ip_address ?? request()->ip(),
        ]);
    }
}
