<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Update Setting</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.settings.index") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route("admin.settings.update", $settings->id) }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-3">
                                        <label class="form-label" for="description">Setting Name: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="text" placeholder="Setting Name" id="description" name="description" value="{{ $settings->description }}" required>
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label class="form-label" for="status">Status <span class="text-danger">*</span></label>
                                        <select class="form-control" name="status" id="status">
                                            <option value="1" {{ $settings->status == 1 ? 'selected' : '' }}>Enable</option>
                                            <option value="0" {{ $settings->status == 0 ? 'selected' : '' }}>Disable</option>
                                        </select>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
