<x-app-layout :assets="$assets ?? []">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script type="text/javascript">
        function checkbal(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: "{{ route('admin.infomt4account') }}",
                data: {
                    id: id
                },
                success: function(data) {
                    $("#button" + id).replaceWith(data);
                }
            });
        }
    </script>
    <div>
        @if (Auth::user()->affiliate != '1')
            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <form action="{{ route('admin.mt4accounts') }}" method="GET" enctype="multipart/form-data">
                            @csrf
                            <div class="row" style="margin-left: 15px; margin-top: 10px;">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Search MT5 Id</label>
                                        <input type="text" class="form-control" name="mt5id"
                                            value="{{ $mt5id }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>Search Email</label>
                                        <input type="text" class="form-control" name="email"
                                            value="{{ $email }}">
                                    </div>
                                </div>
                                <div class="col-md-3"><input class="btn btn-sm btn-success" type="submit" value="Submit"
                                        style="margin-top:26px;"></div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endif
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">MT5 Account List</h4>
                        </div>
                        <div class="card-action">
                            <div style="margin-bottom: 10px;" class="row">
                                <div class="col-lg-12">
                                    @if ($checkadmin == false && Auth::user()->affiliate != '1')
                                        <a class="btn btn-sm btn-success" href="{{ route('admin.mtaccount.create') }}">
                                            Create Mt5 Account
                                        </a>
                                    @endif
                                    @if ($checkadmin == true || Auth::user()->affiliate == '1')
                                        <a class="btn btn-sm btn-success" href="{{ route('admin.openlive') }}">
                                            Create Mt5 Account
                                        </a>
                                    @endif
                                    <a class="btn btn-sm btn-info" href="{{ route('admin.mtaccounts.export') }}">
                                        Export Mt5 Account
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                    <tr class="light">
                                        <th style="text-align: center">Login ID</th>
                                        <th style="text-align: center">Client Name</th>
                                        <th style="text-align: center">Email</th>
                                        <th style="text-align: center">Password</th>
                                        <th style="text-align: center">Group Name</th>
                                        <th style="text-align: center">Leverage</th>
                                        <th style="text-align: center;">Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($accounts as $key => $product)
                                        <tr data-entry-id="{{ $product->loginid }}">
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->loginid ?? '' }}
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->name ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->email ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->mainpass ?? '' }}
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $product->groupname ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->leverage ?? '' }}
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <button class="btn btn-sm btn-success" id="button{{ $product->loginid }}"
                                                    onclick="checkbal({{ $product->loginid }})">View Balance</button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(function() {
            let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ route('admin.products.massDestroy') }}",
                className: 'btn-danger',
                action: function(e, dt, node, config) {
                    var ids = $.map(dt.rows({
                        selected: true
                    }).nodes(), function(entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('{{ trans('global.datatables.zero_selected') }}')

                        return
                    }

                    if (confirm('{{ trans('global.areYouSure') }}')) {
                        $.ajax({
                                headers: {
                                    'x-csrf-token': _token
                                },
                                method: 'POST',
                                url: config.url,
                                data: {
                                    ids: ids,
                                    _method: 'DELETE'
                                }
                            })
                            .done(function() {
                                location.reload()
                            })
                    }
                }
            }
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
            @can('product_delete')
                // dtButtons.push(deleteButton)
            @endcan

            $('.datatable:not(.ajaxTable)').DataTable({
                'iDisplayLength': 600,
                buttons: dtButtons
            })
        })
    </script>
</x-app-layout>
