<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Lead Status History</h4>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                    <tr class="ligth">
                                        <th width="10"></th>
                                        <th style="text-align: center">Lead No.</th>
                                        <th style="text-align: center">Email</th>
                                        <th style="text-align: center;">Status</th>
                                        <th style="text-align: center;">Lead Owner</th>
                                        <th style="text-align: center;">Comment</th>
                                        <th style="text-align: center;">Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($accounts as $key => $product)
                                        <tr data-entry-id="{{ $product->id }}">
                                            <td><input type="checkbox" name="bulk-select" class="user-checkbox"></td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->leadid ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->email ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->status ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php
                                                        $owner = \App\Models\User::select('name')
                                                            ->where('id', $product->leadowner)
                                                            ->first();
                                                        if (!empty($owner)) {
                                                            echo $owner->name;
                                                        }
                                                    ?>
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->note ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->created_at ?? '' }}</p>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(function () {
            let deleteButtonTrans = 'Bulk Assign'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ route('admin.leadsbulk') }}",
                className: 'btn-success',
                action: function (e, dt, node, config) {
                    var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('{{ trans('global.datatables.zero_selected') }}')

                        return
                    }

                    if (confirm('{{ trans('global.areYouSure') }}')) {
                        var encode = btoa(ids);
                        var weburl = '/admin/leadsbulk/' + encode;
                        location.href = weburl;
                        // $.ajax({
                        // headers: {'x-csrf-token': _token},
                        // method: 'POST',
                        // url: config.url,
                        // data: { ids: ids, _method: 'DELETE' }})
                        // .done(function () { location.reload() })
                    }
                }
            }
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
            @can('user_delete')
                dtButtons.push(deleteButton)
            @endcan

            $('.datatable:not(.ajaxTable)').DataTable({ buttons: dtButtons })
        })
    </script>
</x-app-layout>
