<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Deposit List</h4>
                        </div>
                        <div class="card-action">
                            <div style="margin-bottom: 10px;" class="row">
                                <div class="col-lg-12">
                                    <a class="btn btn-sm btn-success" href="{{ route("admin.deposit.create") }}">
                                        Add Deposit
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                    <tr class="ligth">
                                        <th width="10"></th>
                                        <th style="text-align: center">MT5 Id</th>
                                        <th style="text-align: center">Amount</th>
                                        <th style="text-align: center">Notes</th>
                                        <th style="text-align: center">Admin Response</th>
                                        <th style="text-align: center;">Status</th>
                                        <th style="text-align: center;">Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($accounts as $key => $product)
                                        <tr data-entry-id="{{ $product->id }}">
                                            <td><input type="checkbox" name="bulk-select" class="user-checkbox"></td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->mt4account ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->amount ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->clientnote ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->description ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <div class="flex align-items-center list-user-action">
                                                    @if ($product->status == '0')
                                                        <a class="btn btn-sm btn-icon btn-info" href="#">
                                                            Pending
                                                        </a>
                                                    @elseif($product->status == '1')
                                                        <a class="btn btn-sm btn-icon btn-success" href="#">
                                                            Approved
                                                        </a>
                                                    @elseif($product->status == '2')
                                                        <a class="btn btn-sm btn-icon btn-danger" href="#">
                                                            Rejected
                                                        </a>
                                                    @endif
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->created_at ?? '' }}</p>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(function () {
            let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ route('admin.products.massDestroy') }}",
                className: 'btn-danger',
                action: function (e, dt, node, config) {
                    var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('{{ trans('global.datatables.zero_selected') }}')

                        return
                    }

                    if (confirm('{{ trans('global.areYouSure') }}')) {
                        $.ajax({
                        headers: {'x-csrf-token': _token},
                        method: 'POST',
                        url: config.url,
                        data: { ids: ids, _method: 'DELETE' }})
                        .done(function () { location.reload() })
                    }
                }
            }
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
            @can('product_delete')
            // dtButtons.push(deleteButton)
            @endcan

            $('.datatable:not(.ajaxTable)').DataTable({ buttons: dtButtons })
        })
    </script>
</x-app-layout>
