<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Create Affiliate User</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.users.usersaffiliate") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route("admin.users.storeaffiliate") }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="name">Name: <span class="text-danger">*</span></label>
                                        <input class="form-control" value="{{ old('name', isset($user) ? $user->name : '') }}" type="text" placeholder="Affiliate Name" id="name" name="name" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="email">E-Mail: <span class="text-danger">*</span></label>
                                        <input class="form-control" value="{{ old('email', isset($user) ? $user->email : '') }}" type="email" placeholder="Affiliate Email" id="email" name="email" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="mobile">Mobile: <span class="text-danger">*</span></label>
                                        <input class="form-control" value="{{ old('mobile', isset($user) ? $user->mobile : '') }}" type="text" placeholder="Mobile" id="mobile" name="mobile" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="password">Password:</label>
                                        <input class="form-control" value="" type="password" placeholder="Password" id="password" name="password">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="givepermission"><b>Give Permissions</b></label>
                                    <div class="row" style="text-align:center;">
                                        <div class="form-check d-block col-md-2">
                                            <label for="usermanager">User Management</label>
                                            <input type="checkbox" class="form-check-label" id="usermanager" name="usermanager" value="1" class="form-check-input" checked>
                                        </div>
                                        <div class="form-check d-block col-md-2">
                                            <label for="mt4access">Mt5 Accounts</label>
                                            <input type="checkbox" class="form-check-label" id="mt4access" name="mt4access" value="1" class="form-check-input" checked>
                                        </div>
                                        <div class="form-check d-block col-md-2">
                                            <label for="deposit">Deposit</label>
                                            <input type="checkbox" class="form-check-label" id="deposit" name="deposit" value="1" class="form-check-input" checked>
                                        </div>
                                        <div class="form-check d-block col-md-2">
                                            <label for="withdrawal">Withdrawal</label>
                                            <input type="checkbox" class="form-check-label" id="withdrawal" name="withdrawal" value="1" class="form-check-input" checked>
                                        </div>
                                        <div class="form-check d-block col-md-2">
                                            <label for="leads">Leads</label>
                                            <input type="checkbox" class="form-check-label" id="leads" name="leads" value="1" class="form-check-input" checked>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
