<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class Leadstatus extends Model
{
    use SoftDeletes;

    protected $table = 'leadstatus';

    protected $primaryKey = 'id';

	protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'name',
    ];

    protected static function boot()
    {
        parent::boot();

        static::created(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            $attributes = $model->getAttributes();
            $createdAttributes = [];
            foreach ($attributes as $key => $value) {
                if ($key === 'created_at' || $key === 'updated_at') {
                    continue;
                }
                $createdAttributes[] = "$key: '$value'";
            }

            $description = 'Created ' . class_basename($model);
            if (!empty($createdAttributes)) {
                $description .= ' (' . implode(', ', $createdAttributes) . ')';
            }

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'create',
                'description'  => $description,
                'ip_address'   => request()->ip(),
            ]);
        });

        static::updated(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            $changes = $model->getChanges();
            $original = $model->getOriginal();

            $changedFields = [];
            foreach ($changes as $attribute => $newValue) {
                if ($attribute === 'updated_at') {
                    continue;
                }
                $oldValue = $original[$attribute] ?? null;
                $changedFields[] = "$attribute: '$oldValue' → '$newValue'";
            }

            $description = 'Updated ' . class_basename($model);
            if (!empty($changedFields)) {
                $description .= ' (' . implode(', ', $changedFields) . ')';
            }

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'update',
                'description'  => $description,
                'ip_address'   => request()->ip(),
            ]);
        });

        static::deleted(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            $attributes = $model->getAttributes();
            $deletedAttributes = [];
            foreach ($attributes as $key => $value) {
                if ($key === 'created_at' || $key === 'updated_at') {
                    continue;
                }
                $deletedAttributes[] = "$key: '$value'";
            }

            $description = 'Deleted ' . class_basename($model);
            if (!empty($deletedAttributes)) {
                $description .= ' (' . implode(', ', $deletedAttributes) . ')';
            }

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'delete',
                'description'  => $description,
                'ip_address'   => request()->ip(),
            ]);
        });
    }
}
