<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Create MT5 Account</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.mt4accounts") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route("admin.storemt4") }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="userid">Select Client</label>
                                        <select class="form-control" name="userid" id="userid">
                                            @if(count($accounts)>0)
                                                @foreach($accounts as $users)
                                                    <option value="{{$users->id}}">{{$users->name}} ({{$users->email}})</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="groupname">Select Group <span class="text-danger">*</span></label>
                                        <select class="form-control" name="groupname" id="groupname">
                                            <option value="real\INPR_MICR_EUR">EUR</option>
                                            <option value="real\INPR_MICR_USD">USD</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="leverage">Select Leverage</label>
                                        <select class="form-control" name="leverage" id="leverage">
                                            <option value="100">1:100</option>
                                            <option value="200">1:200</option>
                                            <option value="300">1:300</option>
                                            <option value="400">1:400</option>
                                        </select>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
