<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyUserRequest;
use App\Http\Requests\StoreUserRequest;
use App\Http\Requests\UpdateUserRequest;
use App\Mail\DocumentStatusMail;
use App\Mail\WelcomeMail;
use App\Models\Documents;
use App\Models\Leads;
use App\Models\Mtaccount;
use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class UsersController extends Controller
{
    public function messages()
    {
        return [
            'currentpassword.required' => 'current password required',
        ];
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        abort_unless(Gate::allows('user_access'), 403);

        $parts = parse_url($_SERVER['REQUEST_URI']);
        if (!empty($parts['query'])) {
            parse_str($parts['query'], $query);
            $from = $query['fromdate'];
            $to = $query['todate'];
            $comment = '';
            $checkdate = 'yes';
            $fm = $query['fromdate'] . ' 00:00:00';
            $to2 = $query['todate'] . ' 23:59:59';
        } else {
            $getaccpara = null;
            $to = date('Y-m-d');
            $from = date('Y-m-d', strtotime('-7 days'));
            $fm =  $to . '00:00:00';
            $to2 = $from . '23:59:59';
            $checkdate = '';
            $comment = '';
        }
        $checkuser = User::where('id', Auth::user()->id)->first();
        if ($checkuser->affiliate != '1') {
            $users = DB::table('users')
                ->join('role_user', 'users.id', '=', 'role_user.user_id')
                ->select('users.*', 'role_user.role_id');
            $users = $users->where('users.deleted_at', null);
            $users = $users->where('role_user.role_id', '2');
            if (!empty($comment)) {
                //$users = $users->where('users.note', 'like', '%' . $comment . '%');
            }
            if ($checkdate == 'yes') {
                $users = $users->whereBetween('users.created_at', [$fm, $to2]);
            }
            $users = $users->get();
        } else {
            $users = DB::table('users')
                ->join('role_user', 'users.id', '=', 'role_user.user_id')
                ->select('users.*', 'role_user.role_id')
                ->where('role_user.role_id', '2')
                ->where('users.deleted_at', null)
                ->where('users.afid', Auth::user()->id)
                ->get();
        }

        return view('admin.users.index', compact('users', 'to', 'from', 'comment'));
    }

    public function indexusers()
    {
        abort_unless(Gate::allows('user_access'), 403);

        $checkuser = User::where('id', Auth::user()->id)->first();
        if ($checkuser->affiliate != '1') {
            $users = DB::table('users')
                ->join('role_user', 'users.id', '=', 'role_user.user_id')
                ->select('users.*', 'role_user.role_id')
                ->where('users.deleted_at', null)
                ->where('users.affiliate', '1')
                ->get();
        } else {
            $users = array();
        }

        return view('admin.users.indexusers', compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        abort_unless(Gate::allows('user_create'), 403);

        $affiliates = User::where('affiliate', '1')->get();
        $roles = Role::all()->pluck('title', 'id');
        $countries = DB::table('countries')->get();

        return view('admin.users.create', compact('roles', 'affiliates','countries'));
    }

    public function createaffiliate()
    {
        abort_unless(Gate::allows('user_create'), 403);
        if (Auth::user()->affiliate == '1') {
            abort(403);
        }
        $roles = Role::all()->pluck('title', 'id');

        return view('admin.users.createaffiliate', compact('roles'));
    }

    public function changepass()
    {
        return view('admin.users.changepass');
    }

    public function savepass(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'currentpassword' => 'required'
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $checkpass = base64_decode(Auth::user()->mypass);

        if ($request->currentpassword != $checkpass) {
            return redirect()->back()->withErrors(['Enter correct current password']);
        }
        $adduser = array();
        $adduser['password'] = Hash::make($request->password);
        $passencode = base64_encode($request->password);
        //User::update($adduser);
        User::where('id', Auth::user()->id)->update(array(
            'password'     => Hash::make($request->password),
            'mypass' => base64_encode($request->password),
        ));
        return redirect()->back()->with('success', 'Your password changed successfully.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreUserRequest $request)
    {
        abort_unless(Gate::allows('user_create'), 403);
        $data = $request->all();
        $adduser = array();
        $adduser['name'] = $data['name'];
        $adduser['email'] = $data['email'];
        $adduser['mobile'] = $data['mobile'];
        $adduser['country'] = $data['country'];
        $adduser['password'] = Hash::make($data['password']);
        $adduser['mypass'] = base64_encode($data['password']);
        if (!empty($data['afid'])) {
            $adduser['afid'] = $data['afid'];
        }
        $user = User::create($adduser);
        $user->roles()->sync(array('2'));

        $datap1 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890abcefghijklmnopqrstuvwxyz';
        $datap2 = '1234567890abcefghijklmnopqrstuvwxyz';
        $mainpass = substr(str_shuffle($datap1), 0, 8);
        $invepass = substr(str_shuffle($datap2), 0, 8);

        $postfields = array(
            'method' => 'AddUser',
            'key' => '0001',
            'array' =>
            array(
                0 =>
                array(
                    'index' => 0,
                    'agentAccount' => 0,
                    'canTrade' => true,
                    'comment' => 'new user',
                    'group' =>
                    array(
                        'name' => 'real\INPR_MICR_EUR'
                    ),
                    'hasSendReportEnabled' => true,
                    'isEnabled' => true,
                    'leverage' => 100,
                    'password' => $mainpass,
                    'investorPassword' => $invepass,
                    'enable_change_password' => true,

                    'user' =>
                    array(
                        'address' =>
                        array(
                            "address" => "",
                            "city" => "",
                            "state" => "",
                            "zipcode" => "",
                            "country" => $data['country'],
                        ),
                        "name" => $data['name'],
                        "email" => $data['email'],
                        "phone" => $data['mobile']
                    ),

                ),

            ),
        );
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "http://jenya.securedns.us:3001/capitalmanageinv",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($postfields),
            CURLOPT_HTTPHEADER => array(
                "Content-Type: text/plain"
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $getresult = json_decode($response);

        if ($getresult->systemErrorStatus == '') {

            $adduser2 = array();
            $adduser2['userid'] = $user->id;
            $adduser2['loginid'] = $getresult->array[0]->accountID;
            $adduser2['mainpass'] = $mainpass;
            $adduser2['leverage'] = "100";
            $adduser2['groupname'] = "real\INPR_MICR_EUR";

            $product = Mtaccount::create($adduser2);
        }

        return redirect()->route('admin.users.index')->with('success','User added successfully');
    }

    public function storeaffiliate(StoreUserRequest $request)
    {
        abort_unless(Gate::allows('user_create'), 403);
        $data = $request->all();
        $fourRandomDigit = mt_rand(1000, 9999);
        $adduser = array();
        $adduser['name'] = $data['name'];
        $adduser['email'] = $data['email'];
        $adduser['mobile'] = $data['mobile'];
        $adduser['password'] = Hash::make($data['password']);
        $adduser['mypass'] = base64_encode($data['password']);
        $adduser['affiliate'] = '1';
        $adduser['promo'] = 'AF-' . $fourRandomDigit;

        $user = User::create($adduser);
        $user->roles()->sync(array('3'));

        return redirect()->route('admin.users.usersaffiliate')->with('success','Affiliate created successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(User $user)
    {
        abort_unless(Gate::allows('user_show'), 403);

        $user->load('roles');

        return view('admin.users.show', compact('user'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(User $user)
    {
        abort_unless(Gate::allows('user_edit'), 403);

        $roles = Role::all()->pluck('title', 'id');
        $affiliates = User::where('affiliate', '1')->get();
        $user->load('roles');

        return view('admin.users.edit', compact('roles', 'user', 'affiliates'));
    }

    public function myprofile()
    {
        $user = User::where('id', Auth::user()->id)->first();
        $countries = DB::table('countries')->get();
        return view('admin.users.myprofile', compact('user', 'countries'));
    }

    public function updateprofile(Request $request)
    {

        if (!empty($request->name)) {
            $name = $request->name;
        } else {
            $name = Auth::user()->name;
        }
        if (!empty($request->email)) {
            $email = $request->email;
        } else {
            $email = Auth::user()->email;
        }
        if (!empty($request->mobile)) {
            $mobile = $request->mobile;
        } else {
            $mobile = Auth::user()->mobile;
        }
        if (!empty($request->country)) {
            $country = $request->country;
        } else {
            $country = Auth::user()->country;
        }

        User::where('id', Auth::user()->id)->update(array(
            'name'     => $name,
            'email' => $email,
            'mobile' => $mobile,
            'country' => $country,
        ));
        return redirect()->back()->with('success', 'Your profile changed successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateUserRequest $request, User $user)
    {
        abort_unless(Gate::allows('user_edit'), 403);
        if (Auth::user()->affiliate == '1') {
            $checkuser = User::where('id', $request->id)->where('afid', Auth::user()->id)->get();
            if (count($checkuser) == 0) {
                abort(403);
            }
        }

        if (!empty($request->password)) {
            $request['mypass'] = base64_encode($request->password);
        }
        $user->update($request->all());

        return redirect()->route('admin.users.index')->with('success','Updated successfully');
    }

    public function createdocadmin()
    {
        abort_unless(Gate::allows('user_access'), 403);

        $checkuser = User::where('id', Auth::user()->id)->first();
        if ($checkuser->affiliate != '1') {
            $users = DB::table('users')
                ->join('role_user', 'users.id', '=', 'role_user.user_id')
                ->select('users.*', 'role_user.role_id')
                ->where('role_user.role_id', '2')
                ->get();
        } else {
            $users = DB::table('users')
                ->join('role_user', 'users.id', '=', 'role_user.user_id')
                ->select('users.*', 'role_user.role_id')
                ->where('role_user.role_id', '2')
                ->where('users.afid', Auth::user()->id)
                ->get();
        }

        return view('admin.users.createdocadmin', compact('users'));
    }

    public function createdoc()
    {
        return view('admin.users.createdoc');
    }

    public function indexdoc()
    {
        if (Auth::user()->id == '1') {
            $docs = Documents::get();
            return view('admin.users.indexdoc', compact('docs'));
        }
        if (Auth::user()->affiliate == '1') {
            $docs = DB::table('documents')
                ->join('users', 'documents.userid', '=', 'users.id')
                ->select('documents.*', 'users.name')
                ->where('users.afid', Auth::user()->id)
                ->get();
        } else {
            $docs = Documents::where('userid', Auth::user()->id)->get();
        }

        return view('admin.users.indexdoc', compact('docs'));
    }

    public function storedoc(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'identity' => 'required',
            'residential' => 'required'
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $documents = new Documents();
        $documents->userid = Auth::user()->id;
        $identity = $request->file('identity');
        $residential = $request->file('residential');
        $identityfile = str_replace(' ', '_', $identity->getClientOriginalName());
        $residentfile = str_replace(' ', '_', $residential->getClientOriginalName());
        $path = public_path('documents/' . $documents->userid);
        $secondaryPath = '/home/fxdemosi/crm.fxdemo.site/public/documents/' . $documents->userid;

        if (!File::isDirectory($path)) {
            File::makeDirectory($path, 0777, true, true);
        }
        if (!File::isDirectory($secondaryPath)) {
            File::makeDirectory($secondaryPath, 0777, true, true);
        }
        $identity->move($path, $identityfile);
        $residential->move($path, $residentfile);
        File::copy($path . '/' . $identityfile, $secondaryPath . '/' . $identityfile);
        File::copy($path . '/' . $residentfile, $secondaryPath . '/' . $residentfile);
        $documents->identity = $identityfile;
        $documents->resident = $residentfile;
        $documents->save();

        return redirect('admin/users/documents')->with('success','Documents upload successfully');
    }

    public function storedocadmin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'identity' => 'required',
            'residential' => 'required'
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $documents = new Documents();
        $documents->userid = $request->userid;
        $identity = $request->file('identity');

        $residential = $request->file('residential');
        $identityfile = str_replace(' ', '_', $identity->getClientOriginalName());
        $residentfile = str_replace(' ', '_', $residential->getClientOriginalName());
        $path = public_path('documents/' . $request->userid);
        // echo $path;exit;
        $secondaryPath = '/home/fxdemosi/crm.fxdemo.site/public/documents/' . $documents->userid;

        if (!File::isDirectory($path)) {
            File::makeDirectory($path, 0777, true, true);
        }
        if (!File::isDirectory($secondaryPath)) {
            File::makeDirectory($secondaryPath, 0777, true, true);
        }
        $identity->move($path, $identityfile);
        $residential->move($path, $residentfile);
        File::copy($path . '/' . $identityfile, $secondaryPath . '/' . $identityfile);
        File::copy($path . '/' . $residentfile, $secondaryPath . '/' . $residentfile);
        $documents->identity = $identityfile;
        $documents->resident = $residentfile;
        $documents->save();

        return redirect('admin/users/documents')->with('success','Documents upload successfully by Admin');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(User $user)
    {
        abort_unless(Gate::allows('user_delete'), 403);

        $user->forceDelete();

        return back();
    }

    public function uploaddocsum(){
        $appurl = 'https://api.sumsub.com/resources/accessTokens?userId=' . Auth::user()->id . '&levelName=basic-kyc-level';
        $ts = time();
        $url = '/resources/accessTokens?userId=' . Auth::user()->id . '&levelName=basic-kyc-level';
        $string = $ts . 'POST' . $url;
        $sign =  hash_hmac('sha256', $string, 'Z7cqztk7DkmqbaCZwXJJrFhaSlaf3axq');
        //dd($sign);

        $option = array(
            'Content-Type:application/json',
            'X-App-Token: sbx:jfqPDIfUuQIEfElxz54bNqwK.WwCw0b18S3tvUo6NvNNdHYHpazxJPZ5x',
            'X-App-Access-Sig: ' . $sign,
            'X-App-Access-Ts: ' . $ts
        );
        //dd($option);

        $ch = curl_init($appurl);
        curl_setopt($ch, CURLOPT_POSTFIELDS,  array());
        curl_setopt($ch, CURLOPT_HTTPHEADER, $option);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);

        curl_close($ch);
        $finaldata = json_decode($result);
        //echo '<pre>';print_r($finaldata);exit;
        //dd($finaldata);
        if (isset($finaldata->token)) {
            $subtoken = $finaldata->token;
            /* Hivelog::create(array(
				'description' =>$subtoken,
				'userid' =>Auth::user()->id,
				));*/
        } else {
            $subtoken = '';
        }
        // dd($subtoken);


        return view('admin.users.documentuploadsum', array('title' => 'Upload Document', 'subtoken' => $subtoken));
    }

    public function massDestroy(MassDestroyUserRequest $request)
    {
        User::whereIn('id', request('ids'))->forceDelete();

        return response(null, 204);
    }
}
