<?php

namespace App\Http\Controllers;

use App\Models\Deposit;
use App\Models\Leads;
use App\Models\Mtaccount;
use App\Models\User;
use App\Models\Withdraw;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    /*
     * Dashboard Pages Routs
     */
    public function index(Request $request)
    {
        $assets = ['chart', 'animation'];
        if (Auth::user()->status == '2') {
            //return view('admin.deposit.leaddeposit');
            $accounts = Mtaccount::where('userid', Auth::user()->id)->get();
            return view('admin.deposit.create', compact('accounts'));
        }
        $previous_week = strtotime("-1 week +1 day");
        $start_week = strtotime("last sunday midnight", $previous_week);
        $end_week = strtotime("next saturday", $start_week);
        $start_week = date("Y-m-d", $start_week);
        $end_week = date("Y-m-d", $end_week);
        $lastweekdepo = Deposit::where('displaystatus', '1')->whereBetween('created_at', [$start_week, $end_week])->sum('amount');
        $lastweekwith = Withdraw::where('status', '1')->whereBetween('created_at', [$start_week, $end_week])->sum('amount');
        $lastweekuser = User::where('affiliate', '0')->whereBetween('created_at', [$start_week, $end_week])->count();
        // dd($lastweekdepo);
        $totalusers = DB::table('users')->where('affiliate', '0')->where('id', '!=', Auth::user()->id)->count();
        $totalaffiliates = DB::table('users')->where('affiliate', '1')->count();
        $totaldeposit = DB::table('deposit')->where('status', '=', '1')->where('displaystatus', '=', '1')->sum('amount');
        $totalwithdraw = DB::table('withdraw')->where('status', '=', '1')->sum('amount');

        $totalleads = DB::table('leads')->count();
        $totalmt4 = DB::table('mtaccount')->count();
        $myaccounts = DB::table('mtaccount')->where('userid', Auth::user()->id)->count();
        $mydeposit = DB::table('deposit')->where('status', '=', '1')->where('displaystatus', '=', '1')->where('userid', '=', Auth::user()->id)->sum('amount');
        $mywithdraw = DB::table('withdraw')->where('status', '=', '1')->where('userid', '=', Auth::user()->id)->sum('amount');
        $mypendingwithdraw = DB::table('withdraw')->where('status', '=', '0')->where('userid', '=', Auth::user()->id)->count();

        $myclientsdata = DB::table('users')->where('afid', Auth::user()->id)->get();
        $myclients = count($myclientsdata);
        $clientids = array();
        if ($myclients > 0) {
            foreach ($myclientsdata as $account) {
                $clientids[] =     $account->id;
            }
        }
        $mycdeposit = DB::table('deposit')->where('status', '=', '1')->where('displaystatus', '=', '1')->whereIn('userid', $clientids)->sum('amount');
        $mycwithdraw = DB::table('withdraw')->where('status', '=', '1')->whereIn('userid', $clientids)->sum('amount');
        $myleads = DB::table('leads')->where('leadowner', Auth::user()->id)->count();
        $allcli = User::select('id', 'name', 'email', 'mobile', 'created_at')->where('affiliate', '0')->where('id', '!=', Auth::user()->id)->take(10)->orderBy('id', 'desc')->get();
        $lastweekuser = 0;

        $latestdeposit = Deposit::with('user')->select('userid','mt4account','amount','created_at')->where('status', '=', '1')->where('userid','!=',Auth::user()->id)->take(10)->orderBy('id', 'desc')->get();
        $withdrawrequest = DB::table('withdraw')->where('status', '=', '0')->count();
        $depositrequest = DB::table('deposit')->where('status', '=', '0')->count();
        $leveragerequest = DB::table('leverage')->where('status', '=', '0')->count();
        $users = User::select('name', 'created_at')->where('id', '!=', Auth::user()->id)->get();
        foreach ($users as $user) {
            $user->ip_address = $request->ip();
        }

        $today = Carbon::today();
        $todayDeposit = Deposit::whereDate('created_at', $today)->where('status', '=', '1')->sum('amount');
        $todayWithdraw = Withdraw::whereDate('created_at', $today)->where('status', '=', '1')->sum('amount');

        return view('dashboards.dashboard', compact('assets', 'totalaffiliates', 'lastweekuser', 'allcli', 'latestdeposit', 'lastweekwith', 'lastweekdepo', 'totaldeposit', 'totalusers', 'totalwithdraw', 'myaccounts', 'mydeposit', 'totalmt4', 'totalleads', 'mywithdraw', 'mypendingwithdraw', 'myclients', 'mycdeposit', 'mycwithdraw', 'myleads', 'withdrawrequest', 'depositrequest', 'leveragerequest' , 'users', 'todayDeposit', 'todayWithdraw'));
    }

    public function getForexData(Request $request)
    {
        $gettickforexdata = [];
        $url = 'https://api.tradeactive.com/mt5demo/api/api.php?MODE=GetTick';
        $postdata = ['symbol' => ["EURUSD", "AUDCAD", "AUDJPY", "AUDUSD", "EURAUD"], 'GROUP' => "real\\real"];
        $option = ['Content-Type:application/json'];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $option);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));
        $getallw = curl_exec($ch);
        $gettickforexdata = json_decode($getallw);

        return response()->json($gettickforexdata);
    }

    public function getMetalsData()
    {
        $gettickmetalsdata = array();
        $url = 'https://api.tradeactive.com/mt5demo/api/api.php?MODE=GetTick';
        $postdata = array();
        $postdata['symbol'] = ["COPPER","ALUMINIUM","LEAD","ZINC"];
        $postdata['GROUP'] = "real\\real";
        $option = array(
            'Content-Type:application/json'
        );

        $ch = curl_init(str_replace(' ', '', $url));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $option);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));
        $getallw = curl_exec($ch);
        $gettickmetalsdata[] = json_decode($getallw);

        return response()->json($gettickmetalsdata[0]);
    }

    public function getCryptoData()
    {
        $gettickcryptodata = array();
        $url = 'https://api.tradeactive.com/mt5demo/api/api.php?MODE=GetTick';
        $postdata = array();
        $postdata['symbol'] = ["SOLANA","THETA","TRON","UNISWAP","XRP"];
        $postdata['GROUP'] = "real\\real";
        $option = array(
            'Content-Type:application/json'
        );

        $ch = curl_init(str_replace(' ', '', $url));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $option);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));
        $getallw = curl_exec($ch);
        $gettickcryptodata[] = json_decode($getallw);

        return response()->json($gettickcryptodata[0]);
    }

    public function getBitcoinData()
    {
        $gettickcryptodata = array();
        $url = 'https://api.tradeactive.com/mt5demo/api/api.php?MODE=GetTick';
        $postdata = array();
        $postdata['symbol'] = ["BTCCHF","BTCUSD","BTCEUR","BTCGBP"];
        $postdata['GROUP'] = "real\\real";
        $option = array(
            'Content-Type:application/json'
        );

        $ch = curl_init(str_replace(' ', '', $url));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $option);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));
        $getallw = curl_exec($ch);
        $gettickcryptodata[] = json_decode($getallw);

        return response()->json($gettickcryptodata[0]);
    }

    public function signin(Request $request)
    {
        return view('auth.login');
    }
    public function signup(Request $request)
    {
        $countries = DB::table('countries')->get();
        return view('auth.register', compact('countries'));
    }
    public function confirmmail(Request $request)
    {
        return view('auth.confirm-mail');
    }
    public function lockscreen(Request $request)
    {
        return view('auth.lockscreen');
    }
    public function recoverpw(Request $request)
    {
        return view('auth.recoverpw');
    }
    
    public function privacypolicy(Request $request)
    {
        return view('privacy-policy');
    }
    public function termsofuse(Request $request)
    {
        return view('terms-of-use');
    }
}
