<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Deposit extends Model
{
    use SoftDeletes;

		protected $table = 'deposit';

		protected $primaryKey = 'id';

	protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'mt4account',
        'userid',
        'amount',
        'clientnote',
        'description',
		'status',
		'displaystatus',
      	'method',
      	'getdata'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'userid');
    }
}
