import { TrackDirection } from './direction';
import { setStyle } from '../utils/';
var ScrollbarThumb = /** @class */ (function () {
    function ScrollbarThumb(_direction, _minSize) {
        if (_minSize === void 0) { _minSize = 0; }
        this._direction = _direction;
        this._minSize = _minSize;
        /**
         * Thumb element
         */
        this.element = document.createElement('div');
        /**
         * Display size of the thumb
         * will always be greater than `scrollbar.options.thumbMinSize`
         */
        this.displaySize = 0;
        /**
         * Actual size of the thumb
         */
        this.realSize = 0;
        /**
         * Thumb offset to the top
         */
        this.offset = 0;
        this.element.className = "scrollbar-thumb scrollbar-thumb-" + _direction;
    }
    /**
     * Attach to track element
     *
     * @param trackEl Track element
     */
    ScrollbarThumb.prototype.attachTo = function (trackEl) {
        trackEl.appendChild(this.element);
    };
    ScrollbarThumb.prototype.update = function (scrollOffset, containerSize, pageSize) {
        // calculate thumb size
        // pageSize > containerSize -> scrollable
        this.realSize = Math.min(containerSize / pageSize, 1) * containerSize;
        this.displaySize = Math.max(this.realSize, this._minSize);
        // calculate thumb offset
        this.offset = scrollOffset / pageSize * (containerSize + (this.realSize - this.displaySize));
        setStyle(this.element, this._getStyle());
    };
    ScrollbarThumb.prototype._getStyle = function () {
        switch (this._direction) {
            case TrackDirection.X:
                return {
                    width: this.displaySize + "px",
                    '-transform': "translate3d(" + this.offset + "px, 0, 0)",
                };
            case TrackDirection.Y:
                return {
                    height: this.displaySize + "px",
                    '-transform': "translate3d(0, " + this.offset + "px, 0)",
                };
            default:
                return null;
        }
    };
    return ScrollbarThumb;
}());
export { ScrollbarThumb };
//# sourceMappingURL=thumb.js.map