<?php

// Controllers

use App\Http\Controllers\Admin\AffiliateController;
use App\Http\Controllers\Admin\DepositController;
use App\Http\Controllers\Admin\LimportController;
use App\Http\Controllers\Admin\MtaccountController;
use App\Http\Controllers\Admin\PermissionsController;
use App\Http\Controllers\Admin\ProductsController;
use App\Http\Controllers\Admin\RolesController;
use App\Http\Controllers\Admin\UsersController;
use App\Http\Controllers\Admin\WithdrawController;
use App\Http\Controllers\AffiliateApiController;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PaymentController;
use Illuminate\Support\Facades\Artisan;
// Packages
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

require __DIR__.'/auth.php';

Route::get('/storage', function () {
    Artisan::call('storage:link');
});

Route::post('dopayment', [PaymentController::class, 'dopayment'])->name('dopayment');
Route::get('admin/checkcbi', [PaymentController::class, 'checkcbi']);
Route::post('api/createlead', [ApiController::class, 'createlead']);
Route::get('api/getleadstatus', [ApiController::class, 'getleadstatus']);
Route::get('api/depositlist', [ApiController::class, 'depositlist']);
Route::get('api/auto-login', [ApiController::class, 'autologin']);
Route::get('api/getleads', [ApiController::class, 'getleads']);

Route::post('/admin/paymentstatus', [
    'uses' => 'Auth\RegisteredUserController@bitpayment'
]);

Route::group(['prefix' => 'admin', 'as' => 'admin.', 'namespace' => 'App\Http\Controllers\Admin', 'middleware' => ['auth']], function () {
    // Dashboard Routes
    Route::get('/dashboard', [HomeController::class, 'index'])->name('dashboard');
    Route::get('/latestforexdata', [HomeController::class, 'getForexData'])->name('latestforexdata');
    Route::get('/latestmetalsdata', [HomeController::class, 'getMetalsData'])->name('latestmetalsdata');
    Route::get('/latestcryptodata', [HomeController::class, 'getCryptoData'])->name('latestcryptodata');
    Route::get('/latestbitcoindata', [HomeController::class, 'getBitcoinData'])->name('latestbitcoindata');

    Route::delete('permissions/destroy', [PermissionsController::class, 'massDestroy'])->name('permissions.massDestroy');
    Route::resource('permissions', PermissionsController::class);
    Route::delete('roles/destroy', [RolesController::class, 'massDestroy'])->name('roles.massDestroy');
    Route::resource('roles', RolesController::class);

    // Users Module
    Route::get('myprofile', [UsersController::class, 'myprofile'])->name('users.myprofile');
    Route::post('updateprofile', [UsersController::class, 'updateprofile'])->name('users.updateprofile');
    Route::delete('users/destroy', [UsersController::class, 'massDestroy'])->name('users.massDestroy');
    Route::get('users/changepass', [UsersController::class, 'changepass'])->name('users.changepass');
    Route::post('users/savepass', [UsersController::class, 'savepass'])->name('users.savepass');

    // Affiliate
    Route::get('users-affiliate', [UsersController::class, 'indexusers'])->name('users.usersaffiliate');
    Route::get('users/createaffiliate', [UsersController::class, 'createaffiliate'])->name('users.createaffiliate');
    Route::post('users/storeaffiliate', [UsersController::class, 'storeaffiliate'])->name('users.storeaffiliate');
    // Subadmin
    Route::get('users/assignsub', [UsersController::class, 'assignsub'])->name('users.assignsub');
    Route::post('users/storesub', [UsersController::class, 'storesub'])->name('users.storesub');
    Route::get('users/createsubadmin', [UsersController::class, 'createsubadmin'])->name('users.createsubadmin');
    Route::post('users/storesubadmin', [UsersController::class, 'storesubadmin'])->name('users.storesubadmin');
    // Documents
    Route::get('users/documents', [UsersController::class, 'indexdoc'])->name('users.documents');
    // Document Verification code start
	Route::get('users/documentsum', [UsersController::class, 'uploaddocsum'])->name('users.uploaddocsum');
	// Document Verification code ends
    Route::get('users/uploaddoc', [UsersController::class, 'createdoc'])->name('users.uploaddoc');
    Route::post('users/storedoc', [UsersController::class, 'storedoc'])->name('users.storedoc');
    Route::get('users/uploaddocadmin', [UsersController::class, 'createdocadmin'])->name('users.uploaddocadmin');
    Route::post('users/storedocadmin', [UsersController::class, 'storedocadmin'])->name('users.storedocadmin');
    Route::resource('users', UsersController::class);

    Route::delete('products/destroy', [ProductsController::class, 'massDestroy'])->name('products.massDestroy');
    Route::resource('products', ProductsController::class);

    // MT5
    Route::get('changemt4password', [MtaccountController::class, 'changemt4password'])->name('changemt4pass');
    Route::get('mt4accounts', [MtaccountController::class, 'adminindex'])->name('mt4accounts');
    Route::post('storemt4', [MtaccountController::class, 'storedmin'])->name('storemt4');
    Route::post('storemt4pass', [MtaccountController::class, 'storemt4pass'])->name('mt4account.savepass');
    Route::get('openlive', [MtaccountController::class, 'admincreate'])->name('openlive');
    Route::get('opendemoaccount', [MtaccountController::class, 'opendemoaccount'])->name('opendemoaccount');
	Route::get('demoaccounts', [MtaccountController::class, 'demoaccounts'])->name('demoaccounts');
	Route::post('storedemoaccount', [MtaccountController::class, 'storedemo'])->name('storedemoaccount');
    Route::resource('mtaccount', MtaccountController::class);

    // OPen/Close Trade
    Route::get('client/openposition', [MtaccountController::class, 'clientopen'])->name('client.openposition');
  	Route::get('client/closetrades', [MtaccountController::class, 'closetrades'])->name('client.closetrades');
    // Route::get('client/openpositions', [MtaccountController::class, 'crmopen'])->name('client.openpositions');

    // Leverage
    Route::get('leverage', [MtaccountController::class, 'leverage'])->name('leverage');
	Route::get('leverage/create', [MtaccountController::class, 'leveragerequest'])->name('leveragecreate');
	Route::post('leveragestore', [MtaccountController::class, 'storeleverage'])->name('leveragestore');
	Route::get('editleverage/{id}', [MtaccountController::class, 'leverageapprove']);
	Route::post('leverageapprovestore', [MtaccountController::class, 'leverageapprovestore'])->name('leverageapprovestore');

    // Withdraw
    Route::get('transferlist', [WithdrawController::class, 'internaltransfer'])->name('transferlist');
	Route::get('internaltransfer', [WithdrawController::class, 'createtransfer'])->name('internaltransfer');
	Route::post('internalstore', [WithdrawController::class, 'storetransfer'])->name('internalstore');
    Route::get('withdrawapprove/{id}', [WithdrawController::class, 'editwithdraw']);
	Route::post('withdrawapproved', [WithdrawController::class, 'withdrawapproved'])->name('withdrawapproved');
    Route::get('withdrawlist', [WithdrawController::class, 'adminindex'])->name('withdrawlist');
    Route::get('manualwithdraw', [WithdrawController::class, 'manualwithdraw'])->name('manualwithdraw');
    Route::post('storemanualwithdraw', [WithdrawController::class, 'storemanualwithdraw'])->name('storemanualwithdraw');
    Route::resource('withdraw', WithdrawController::class);

    // Deposit
    Route::get('depositlist', [DepositController::class, 'adminindex'])->name('depositlist');
    Route::get('checkcode', [DepositController::class, 'getcode'])->name('checkcode');
    Route::get('manualdeposit', [DepositController::class, 'manualdeposit'])->name('manualdeposit');
	Route::post('storemanual', [DepositController::class, 'storemanual'])->name('storemanual');
    Route::resource('deposit', DepositController::class);

    Route::get('bulkuser/{id?}', [UsersController::class, 'bulkuser'])->name('bulkuser');

    // AF
    Route::get('myuserlist', [AffiliateController::class, 'index'])->name('myuserlist');
    Route::get('leads', [AffiliateController::class, 'leadindex'])->name('leads');
    Route::get('leadsbulk/{id?}', [AffiliateController::class, 'leadsbulk'])->name('leadsbulk');
	Route::get('leadhist/{id?}', [AffiliateController::class, 'leadhist'])->name('leadhist');
    Route::get('leads/create', [AffiliateController::class, 'createleads'])->name('leads.create');
    Route::post('storeleads', [AffiliateController::class, 'storeleads'])->name('storeleads');
    Route::get('editleads/{id}', [AffiliateController::class, 'leadsedit']);
    Route::post('leadsupdate', [AffiliateController::class, 'leadsupdate'])->name('leadsupdate');
    Route::get('clientsmt4account', [AffiliateController::class, 'myclientaccounts'])->name('clientsmt4account');
    Route::resource('lead', AffiliateController::class);

    // Lead Import
    Route::get('leads/import', [LimportController::class, 'leadimport']);
    Route::post('storelimport', [LimportController::class, 'storelimport'])->name('storelimport');
});

//Auth pages Routs
Route::group(['prefix' => 'auth'], function() {
    Route::get('signin', [HomeController::class, 'signin'])->name('auth.signin');
    Route::get('signup', [HomeController::class, 'signup'])->name('auth.signup');
    Route::get('confirmmail', [HomeController::class, 'confirmmail'])->name('auth.confirmmail');
    Route::get('lockscreen', [HomeController::class, 'lockscreen'])->name('auth.lockscreen');
    Route::get('recoverpw', [HomeController::class, 'recoverpw'])->name('auth.recoverpw');
    Route::get('userprivacysetting', [HomeController::class, 'userprivacysetting'])->name('auth.userprivacysetting');
    // Social Login for Registration
    Route::get('/register/google/redirect', [RegisteredUserController::class, 'redirectToGoogleForRegistration'])->name('auth.google.register.redirect');
    Route::get('/register/google/callback', [RegisteredUserController::class, 'handleGoogleRegistrationCallback'])->name('auth.google.register.callback');
});

//Extra Page Routs
Route::get('privacy-policy', [HomeController::class, 'privacypolicy'])->name('pages.privacy-policy');
Route::get('terms-of-use', [HomeController::class, 'termsofuse'])->name('pages.term-of-use');

Route::resource('apikeys',AffiliateApiController::class);
Route::get('apikeys', [AffiliateApiController::class, 'index'])->name('apikeys');
Route::get('apikeys/create', [AffiliateApiController::class, 'create']);
Route::post('storeapikeys', [AffiliateApiController::class, 'store'])->name('storeapikeys');
Route::delete('apikeys/destroy/{id}',[AffiliateApiController::class, 'destroy'])->name('apikeys.destroy');
