<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Blocked IP's</h4>
                        </div>
                        <div class="card-action">
                            <div style="margin-bottom: 10px;" class="row">
                                <div class="col-lg-12">
                                    <a class="btn btn-sm btn-success" href="{{ route("admin.blockedip.create") }}">
                                        Add Block Access
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                    <tr class="light">
                                        <th style="text-align: center">ID</th>
                                        <th style="text-align: center">Blocked Access</th>
                                        <th style="text-align: center">IP</th>
                                        <th style="text-align: center">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($blockedips as $ips)
                                        <tr data-entry-id="{{ $ips->id }}">
                                            <td class="text-center">{{ $ips->id ?? '' }}</td>
                                            <td class="text-center">{{ $ips->role_access_block ?? '' }}</td>
                                            <td class="text-center">{{ $ips->ip ?? '' }}</td>
                                            <td class="text-center">
                                                <?php
                                                    if ($ips->status == "1") {
                                                        echo "Blocked";
                                                    } elseif ($ips->status == "0") {
                                                        echo "Unblock";
                                                    }
                                                ?>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(function() {
            let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ route('admin.products.massDestroy') }}",
                className: 'btn-danger',
                action: function(e, dt, node, config) {
                    var ids = $.map(dt.rows({
                        selected: true
                    }).nodes(), function(entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('{{ trans('global.datatables.zero_selected') }}')

                        return
                    }

                    if (confirm('{{ trans('global.areYouSure') }}')) {
                        $.ajax({
                                headers: {
                                    'x-csrf-token': _token
                                },
                                method: 'POST',
                                url: config.url,
                                data: {
                                    ids: ids,
                                    _method: 'DELETE'
                                }
                            })
                            .done(function() {
                                location.reload()
                            })
                    }
                }
            }

            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
            @can('product_delete')
                // dtButtons.push(deleteButton)
            @endcan

            $('.datatable:not(.ajaxTable)').DataTable({
                buttons: dtButtons
            })
        });
    </script>
</x-app-layout>
