<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Documents</h4>
                        </div>
                        @can('user_client')
                            <div class="card-action">
                                <div style="margin-bottom: 10px;" class="row">
                                    <div class="col-lg-12">
                                        <a class="btn btn-sm btn-success" href="{{ route("admin.users.uploaddoc") }}">
                                            Upload Documents
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endcan
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                <tr class="ligth">
                                    <th width="10"></th>
                                    <th style="text-align: center">ID</th>
                                    <th style="text-align: center">Name</th>
                                    <th style="text-align: center">Identity Proof</th>
                                    <th style="text-align: center">Residential Proof</th>
                                    <th style="text-align: center">Status</th>
                                    <th style="min-width: 100px; text-align:center;">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                    @foreach ($docs as $key => $user)
                                        <tr data-entry-id="{{ $user->id }}">
                                            <td><input type="checkbox" name="bulk-select" class="user-checkbox"></td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $user->id ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php
                                                        $getname = \App\Models\User::select('name')->where('id',$user->userid)->first();
                                                        echo $getname->name;
                                                    ?>
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <img width="80" src="{{ 'https://cabinet.fxdemo.site/public/documents/' . $user->userid . '/' . $user->identity }}">
                                                    <a class="btn btn-sm btn-info" href="{{ asset('documents/' . $user->userid . '/' . $user->identity) }}" download>Download</a>
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <img width="80" src="{{ 'https://cabinet.fxdemo.site/public/documents/' . $user->userid . '/' . $user->resident }}">
                                                    <a class="btn btn-sm btn-info" href="{{ asset('documents/' . $user->userid . '/' . $user->resident) }}" download>Download</a>
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    @php
                                                        $statusLabels = [
                                                            0 => 'Pending',
                                                            1 => 'Approved',
                                                            2 => 'Rejected',
                                                        ];
                                                        $status = $statusLabels[$user->status] ?? 'Unknown';
                                                    @endphp
                                                    @if($user->status == 0)
                                                        <span class="btn btn-sm btn-warning">{{ $status }}</span>
                                                    @elseif($user->status == 1)
                                                        <span class="btn btn-sm btn-success">{{ $status }}</span>
                                                    @elseif($user->status == 2)
                                                        <span class="btn btn-sm btn-danger">{{ $status }}</span>
                                                    @endif
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <div class="flex align-items-center list-user-action">
                                                    @if($user->status == 1)
                                                        <span class="btn btn-sm btn-primary" style="font-size: medium;">Approved</span>
                                                    @elseif($user->status == 2)
                                                        <span class="btn btn-sm btn-danger" style="font-size: medium;">Rejected</span>
                                                    @else
                                                        <form id="approveForm-{{ $user->id }}" action="{{ url('admin/users/documents/' . $user->id . '/approve') }}" method="POST" style="display: inline-block;">
                                                            @csrf
                                                            <button type="button" class="btn btn-sm btn-success" onclick="confirmApprove({{ $user->id }})">Approve</button>
                                                        </form>

                                                        <form id="rejectForm-{{ $user->id }}" action="{{ url('admin/users/documents/' . $user->id . '/reject') }}" method="POST" style="display: inline-block;">
                                                            @csrf
                                                            <button type="button" class="btn btn-sm btn-danger" onclick="confirmReject({{ $user->id }})">Reject</button>
                                                        </form>
                                                    @endif
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(function () {
            let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ url('admin/users/documents') }}",
                className: 'btn-danger',
                action: function (e, dt, node, config) {
                var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
                    return $(entry).data('entry-id')
                });

                if (ids.length === 0) {
                    alert('{{ trans('global.datatables.zero_selected') }}')

                    return
                }

                if (confirm('{{ trans('global.areYouSure') }}')) {
                    $.ajax({
                    headers: {'x-csrf-token': _token},
                    method: 'POST',
                    url: config.url,
                    data: { ids: ids, _method: 'DELETE' }})
                    .done(function () { location.reload() })
                }
                }
            }
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)


            $('.datatable:not(.ajaxTable)').DataTable({ buttons: dtButtons })
        })

        function confirmApprove(userId) {
            if (confirm('Are you sure you want to approve this document?')) {
                $.ajax({
                    type: "POST",
                    url: "{{ url('admin/users/documents') }}/" + userId + "/approve",
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function (response) {
                        location.reload();
                    },
                    error: function (xhr) {
                        alert('Error approving the document.');
                    }
                });
            }
        }

        function confirmReject(userId) {
            if (confirm('Are you sure you want to reject this document?')) {
                $.ajax({
                    type: "POST",
                    url: "{{ url('admin/users/documents') }}/" + userId + "/reject",
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function (response) {
                        location.reload();
                    },
                    error: function (xhr) {
                        alert('Error rejecting the document.');
                    }
                });
            }
        }
    </script>
</x-app-layout>
