<?php

// Controllers

use App\Http\Controllers\Admin\AffiliateController;
use App\Http\Controllers\Admin\BlockedIpsController;
use App\Http\Controllers\Admin\CreditinController;
use App\Http\Controllers\Admin\CreditoutController;
use App\Http\Controllers\Admin\DepositController;
use App\Http\Controllers\Admin\LeadstatusController;
use App\Http\Controllers\Admin\LimportController;
use App\Http\Controllers\Admin\LogsController;
use App\Http\Controllers\Admin\MtaccountController;
use App\Http\Controllers\Admin\PermissionsController;
use App\Http\Controllers\Admin\ProductsController;
use App\Http\Controllers\Admin\RolesController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\UsersController;
use App\Http\Controllers\Admin\WithdrawController;
use App\Http\Controllers\AffiliateApiController;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PaymentController;
use Illuminate\Support\Facades\Artisan;
// Packages
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

require __DIR__.'/auth.php';

Route::get('/storage', function () {
    Artisan::call('storage:link');
});

Route::post('dopayment', [PaymentController::class, 'dopayment'])->name('dopayment');
Route::get('admin/checkcbi', [PaymentController::class, 'checkcbi']);
Route::post('api/createlead', [ApiController::class, 'createlead']);
Route::get('api/getleadstatus', [ApiController::class, 'getleadstatus']);
Route::get('api/depositlist', [ApiController::class, 'depositlist']);
Route::get('api/auto-login', [ApiController::class, 'autologin']);
Route::get('api/getleads', [ApiController::class, 'getleads']);

Route::post('/admin/paymentstatus', [
    'uses' => 'Auth\RegisteredUserController@bitpayment'
]);

Route::group(['prefix' => 'admin', 'as' => 'admin.', 'namespace' => 'App\Http\Controllers\Admin', 'middleware' => ['auth']], function () {
    // Dashboard Routes
    Route::get('/dashboard', [HomeController::class, 'index'])->name('dashboard');
    Route::get('/api/get-lead-data', [HomeController::class, 'getLeadData']);
    Route::get('/api/users/country/{country}', [HomeController::class, 'getUsersByCountry']);

    Route::delete('permissions/destroy', [PermissionsController::class, 'massDestroy'])->name('permissions.massDestroy');
    Route::resource('permissions', PermissionsController::class);
    Route::delete('roles/destroy', [RolesController::class, 'massDestroy'])->name('roles.massDestroy');
    Route::resource('roles', RolesController::class);

    // Blocekd IP's
    Route::resource('blockedip', BlockedIpsController::class);

    // Users Module
    Route::get('myprofile', [UsersController::class, 'myprofile'])->name('users.myprofile');
    Route::post('updateprofile', [UsersController::class, 'updateprofile'])->name('users.updateprofile');
    Route::delete('users/destroy', [UsersController::class, 'massDestroy'])->name('users.massDestroy');
    Route::get('users/changepass', [UsersController::class, 'changepass'])->name('users.changepass');
    Route::post('users/savepass', [UsersController::class, 'savepass'])->name('users.savepass');

    Route::get('users/showUser/{user}', [UsersController::class, 'showUser'])->name('users.showUser');
    Route::get('users/deposit/{login}', [UsersController::class, 'depositForm'])->name('users.deposit');
    Route::post('users/deposit/{login}', [UsersController::class, 'storeDeposit'])->name('users.deposit.store');
    Route::get('users/withdraw/{login}', [UsersController::class, 'withdrawForm'])->name('users.withdraw');
    Route::post('users/withdraw/{login}', [UsersController::class, 'storeWithdraw'])->name('users.withdraw.store');
    Route::get('users/creditin/{login}', [UsersController::class, 'creditinForm'])->name('users.creditin');
    Route::post('users/creditin/{login}', [UsersController::class, 'storeCreditin'])->name('users.creditin.store');
    Route::get('users/creditout/{login}', [UsersController::class, 'creditoutForm'])->name('users.creditout');
    Route::post('users/creditout/{login}', [UsersController::class, 'storeCreditout'])->name('users.creditout.store');
    Route::get('users/leverage/{login}', [UsersController::class, 'leverageForm'])->name('users.leverage');
    Route::post('users/leverage/{login}', [UsersController::class, 'storeLeverage'])->name('users.leverage.store');

    // Send Password
    Route::post('/admin/users/{user}/send-password', [UsersController::class, 'sendPassword'])->name('users.sendPassword');

    // Affiliate
    Route::get('users-affiliate', [UsersController::class, 'indexusers'])->name('users.usersaffiliate');
    Route::get('users/createaffiliate', [UsersController::class, 'createaffiliate'])->name('users.createaffiliate');
    Route::post('users/storeaffiliate', [UsersController::class, 'storeaffiliate'])->name('users.storeaffiliate');
    // Subadmin
    Route::get('users/assignsub', [UsersController::class, 'assignsub'])->name('users.assignsub');
    Route::post('users/storesub', [UsersController::class, 'storesub'])->name('users.storesub');
    Route::get('users/createsubadmin', [UsersController::class, 'createsubadmin'])->name('users.createsubadmin');
    Route::post('users/storesubadmin', [UsersController::class, 'storesubadmin'])->name('users.storesubadmin');
    // Documents
    Route::get('users/documents', [UsersController::class, 'indexdoc'])->name('users.documents');
    Route::post('users/documents/{id}/approve', [UsersController::class, 'approve'])->name('users.approve');
    Route::post('users/documents/{id}/reject', [UsersController::class, 'reject'])->name('users.reject');
	Route::delete('users/documents/{id}', [UsersController::class, 'docdestroy'])->name('users.documentsdestroy');
    Route::get('users/uploaddoc', [UsersController::class, 'createdoc'])->name('users.uploaddoc');
    Route::post('users/storedoc', [UsersController::class, 'storedoc'])->name('users.storedoc');
    Route::get('users/uploaddocadmin', [UsersController::class, 'createdocadmin'])->name('users.uploaddocadmin');
    Route::post('users/storedocadmin', [UsersController::class, 'storedocadmin'])->name('users.storedocadmin');
    Route::resource('users', UsersController::class);

    Route::delete('products/destroy', [ProductsController::class, 'massDestroy'])->name('products.massDestroy');
    Route::resource('products', ProductsController::class);

    // MT5
    Route::get('changemt4password', [MtaccountController::class, 'changemt4password'])->name('changemt4pass');
    Route::get('mt4accounts', [MtaccountController::class, 'adminindex'])->name('mt4accounts');
    Route::post('storemt4', [MtaccountController::class, 'storedmin'])->name('storemt4');
    Route::post('storemt4pass', [MtaccountController::class, 'storemt4pass'])->name('mt4account.savepass');
    Route::get('openlive', [MtaccountController::class, 'admincreate'])->name('openlive');
    Route::get('opendemoaccount', [MtaccountController::class, 'opendemoaccount'])->name('opendemoaccount');
	Route::get('demoaccounts', [MtaccountController::class, 'demoaccounts'])->name('demoaccounts');
	Route::post('storedemoaccount', [MtaccountController::class, 'storedemo'])->name('storedemoaccount');
    Route::post('infomt4account', [MtaccountController::class, 'infomt4account'])->name('infomt4account');
    Route::get('updatemtbl', [MtaccountController::class, 'updatemtbl'])->name('updatemtbl');
    Route::resource('mtaccount', MtaccountController::class);

    // OPen/Close Trade
    Route::get('client/openposition', [MtaccountController::class, 'clientopen'])->name('client.openposition');
  	Route::get('client/closetrades', [MtaccountController::class, 'closetrades'])->name('client.closetrades');
    // Route::get('client/openpositions', [MtaccountController::class, 'crmopen'])->name('client.openpositions');

    // Withdraw
    Route::get('transferlist', [WithdrawController::class, 'internaltransfer'])->name('transferlist');
	Route::get('internaltransfer', [WithdrawController::class, 'createtransfer'])->name('internaltransfer');
	Route::post('internalstore', [WithdrawController::class, 'storetransfer'])->name('internalstore');
    Route::get('withdrawapprove/{id}', [WithdrawController::class, 'editwithdraw']);
	Route::post('withdrawapproved', [WithdrawController::class, 'withdrawapproved'])->name('withdrawapproved');
    Route::get('withdrawlist', [WithdrawController::class, 'adminindex'])->name('withdrawlist');
    Route::get('manualwithdraw', [WithdrawController::class, 'manualwithdraw'])->name('manualwithdraw');
    Route::post('storemanualwithdraw', [WithdrawController::class, 'storemanualwithdraw'])->name('storemanualwithdraw');
    Route::resource('withdraw', WithdrawController::class);

    // Deposit
    Route::get('depositapprove/{id}', [DepositController::class, 'editdeposit']);
	Route::post('depositapproved', [DepositController::class, 'depositapproved'])->name('depositapproved');
    Route::get('depositlist', [DepositController::class, 'adminindex'])->name('depositlist');
    Route::get('checkcode', [DepositController::class, 'getcode'])->name('checkcode');
    Route::get('manualdeposit', [DepositController::class, 'manualdeposit'])->name('manualdeposit');
	Route::post('storemanual', [DepositController::class, 'storemanual'])->name('storemanual');
    Route::resource('deposit', DepositController::class);

    // Creditin
    Route::get('creditinlist', [CreditinController::class, 'adminindex'])->name('creditinlist');
    Route::get('creditindepo', [CreditinController::class, 'creditindepo'])->name('creditindepo');
    Route::post('storecreditin', [CreditinController::class, 'storecreditin'])->name('storecreditin');
    Route::resource('creditin', CreditinController::class);

    // Creditout
    Route::get('creditoutlist', [CreditoutController::class, 'adminindex'])->name('creditoutlist');
    Route::get('creditoutdepo', [CreditoutController::class, 'creditoutdepo'])->name('creditoutdepo');
    Route::post('storecreditout', [CreditoutController::class, 'storecreditout'])->name('storecreditout');
    Route::resource('creditout', CreditoutController::class);

    Route::get('bulkuser/{id?}', [UsersController::class, 'bulkuser'])->name('bulkuser');

    // AF
    Route::get('myuserlist', [AffiliateController::class, 'index'])->name('myuserlist');
    Route::get('leads', [AffiliateController::class, 'leadindex'])->name('leads');
    Route::get('leadsbulk/{id?}', [AffiliateController::class, 'leadsbulk'])->name('leadsbulk');
	Route::get('leadhist/{id?}', [AffiliateController::class, 'leadhist'])->name('leadhist');
    Route::get('leads/create', [AffiliateController::class, 'createleads'])->name('leads.create');
    Route::post('storeleads', [AffiliateController::class, 'storeleads'])->name('storeleads');
    Route::get('editleads/{id}', [AffiliateController::class, 'leadsedit']);
    Route::post('leadsupdate', [AffiliateController::class, 'leadsupdate'])->name('leadsupdate');
    Route::get('clientsmt4account', [AffiliateController::class, 'myclientaccounts'])->name('clientsmt4account');
    Route::post('storeappointment', [AffiliateController::class, 'storeAppointment'])->name('storeAppointment');
    Route::get('calendar', [AffiliateController::class, 'calendar'])->name('calendar');
    Route::get('appointments/{id}', [AffiliateController::class, 'getAppointments'])->name('appointments.get');

    Route::resource('lead', AffiliateController::class);

    // Lead Status
    Route::resource('leadstatus', LeadstatusController::class);
    Route::get('ftdLead', [LeadstatusController::class, 'ftdStatus'])->name('ftdLead');
    Route::get('callbackLead', [LeadstatusController::class, 'callbackStatus'])->name('callbackLead');
    Route::get('confirmedLead', [LeadstatusController::class, 'confirmedStatus'])->name('confirmedLead');
    Route::get('hotLead', [LeadstatusController::class, 'hotStatus'])->name('hotLead');

    // Lead Import
    Route::get('leads/import', [LimportController::class, 'leadimport']);
    Route::post('storelimport', [LimportController::class, 'storelimport'])->name('storelimport');

    // Export
    Route::get('leads/export', [AffiliateController::class, 'exportLeads'])->name('leads.export');
    Route::get('clients/export', [UsersController::class, 'exportClients'])->name('clients.export');
    Route::get('mtaccounts/export', [MtaccountController::class, 'exportMt5account'])->name('mtaccounts.export');

    // Leverage
    Route::get('leverage', [MtaccountController::class, 'leverage'])->name('leverage');
	Route::get('leverage/create', [MtaccountController::class, 'leveragerequest'])->name('leveragecreate');
	Route::post('leveragestore', [MtaccountController::class, 'storeleverage'])->name('leveragestore');
	Route::get('editleverage/{id}', [MtaccountController::class, 'leverageapprove']);
	Route::post('leverageapprovestore', [MtaccountController::class, 'leverageapprovestore'])->name('leverageapprovestore');

    // Setting
    Route::resource('settings', SettingController::class);

    // Setting
    Route::resource('logs', LogsController::class);
});

//Auth pages Routs
Route::group(['prefix' => 'auth'], function() {
    Route::get('signin', [HomeController::class, 'signin'])->name('auth.signin');
    Route::get('signup', [HomeController::class, 'signup'])->name('auth.signup');
    Route::get('confirmmail', [HomeController::class, 'confirmmail'])->name('auth.confirmmail');
    Route::get('lockscreen', [HomeController::class, 'lockscreen'])->name('auth.lockscreen');
    Route::get('recoverpw', [HomeController::class, 'recoverpw'])->name('auth.recoverpw');
    Route::get('userprivacysetting', [HomeController::class, 'userprivacysetting'])->name('auth.userprivacysetting');
});

//Extra Page Routs
Route::get('privacy-policy', [HomeController::class, 'privacypolicy'])->name('pages.privacy-policy');
Route::get('terms-of-use', [HomeController::class, 'termsofuse'])->name('pages.term-of-use');

Route::resource('apikeys',AffiliateApiController::class);
Route::get('apikeys', [AffiliateApiController::class, 'index'])->name('apikeys');
Route::get('apikeys/create', [AffiliateApiController::class, 'create']);
Route::post('storeapikeys', [AffiliateApiController::class, 'store'])->name('storeapikeys');
Route::delete('apikeys/destroy/{id}',[AffiliateApiController::class, 'destroy'])->name('apikeys.destroy');
